/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.registry.NetherBlocks;

public class BlockBrownLargeMushroom
extends BlockBaseNotFull
implements AddMineableAxe {
    private static final VoxelShape TOP_CENTER_SHAPE = BlockBrownLargeMushroom.m_49796_((double)0.0, (double)0.1, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape TOP_EDGE_SHAPE = BlockBrownLargeMushroom.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = BlockBrownLargeMushroom.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final EnumProperty<BNBlockProperties.BrownMushroomShape> SHAPE = BNBlockProperties.BROWN_MUSHROOM_SHAPE;
    private static final BNBlockProperties.BrownMushroomShape[] ROT_SIDE = new BNBlockProperties.BrownMushroomShape[]{BNBlockProperties.BrownMushroomShape.SIDE_N, BNBlockProperties.BrownMushroomShape.SIDE_E, BNBlockProperties.BrownMushroomShape.SIDE_S, BNBlockProperties.BrownMushroomShape.SIDE_W};
    private static final BNBlockProperties.BrownMushroomShape[] ROT_CORNER = new BNBlockProperties.BrownMushroomShape[]{BNBlockProperties.BrownMushroomShape.CORNER_N, BNBlockProperties.BrownMushroomShape.CORNER_E, BNBlockProperties.BrownMushroomShape.CORNER_S, BNBlockProperties.BrownMushroomShape.CORNER_W};

    public BlockBrownLargeMushroom() {
        super(Materials.makeNetherWood(MapColor.f_283748_).m_60978_(1.0f).m_60955_());
        this.setDropItself(false);
    }

    @Environment(value=EnvType.CLIENT)
    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        BNBlockProperties.BrownMushroomShape shape = (BNBlockProperties.BrownMushroomShape)((Object)state.m_61143_(SHAPE));
        return shape == BNBlockProperties.BrownMushroomShape.BOTTOM || shape == BNBlockProperties.BrownMushroomShape.MIDDLE ? new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem()) : new ItemStack((ItemLike)Items.f_41952_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{SHAPE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        BNBlockProperties.BrownMushroomShape shape = (BNBlockProperties.BrownMushroomShape)((Object)state.m_61143_(SHAPE));
        if (shape == BNBlockProperties.BrownMushroomShape.TOP) {
            return TOP_CENTER_SHAPE;
        }
        if (shape == BNBlockProperties.BrownMushroomShape.MIDDLE || shape == BNBlockProperties.BrownMushroomShape.BOTTOM) {
            return MIDDLE_SHAPE;
        }
        return TOP_EDGE_SHAPE;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        BNBlockProperties.BrownMushroomShape shape = (BNBlockProperties.BrownMushroomShape)((Object)state.m_61143_(SHAPE));
        int index = this.getRotationIndex(shape, ROT_SIDE);
        if (index < 0) {
            index = this.getRotationIndex(shape, ROT_CORNER);
            if (index < 0) {
                return state;
            }
            int offset = this.rotOffset(rotation);
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ROT_CORNER[index + offset & 3]));
        }
        int offset = this.rotOffset(rotation);
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)ROT_SIDE[index + offset & 3]));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        BNBlockProperties.BrownMushroomShape shape = (BNBlockProperties.BrownMushroomShape)((Object)state.m_61143_(SHAPE));
        int index = this.getRotationIndex(shape, ROT_SIDE);
        if (index < 0) {
            index = this.getRotationIndex(shape, ROT_CORNER);
            if (index < 0) {
                return state;
            }
            if (mirror == Mirror.FRONT_BACK) {
                if (shape == BNBlockProperties.BrownMushroomShape.CORNER_E) {
                    shape = BNBlockProperties.BrownMushroomShape.CORNER_W;
                } else if (shape == BNBlockProperties.BrownMushroomShape.CORNER_W) {
                    shape = BNBlockProperties.BrownMushroomShape.CORNER_E;
                }
            } else if (mirror == Mirror.LEFT_RIGHT) {
                if (shape == BNBlockProperties.BrownMushroomShape.CORNER_N) {
                    shape = BNBlockProperties.BrownMushroomShape.CORNER_S;
                } else if (shape == BNBlockProperties.BrownMushroomShape.CORNER_S) {
                    shape = BNBlockProperties.BrownMushroomShape.CORNER_N;
                }
            }
            return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)shape));
        }
        if (mirror == Mirror.FRONT_BACK) {
            if (shape == BNBlockProperties.BrownMushroomShape.SIDE_E) {
                shape = BNBlockProperties.BrownMushroomShape.SIDE_W;
            } else if (shape == BNBlockProperties.BrownMushroomShape.SIDE_W) {
                shape = BNBlockProperties.BrownMushroomShape.SIDE_E;
            }
        } else if (mirror == Mirror.LEFT_RIGHT) {
            if (shape == BNBlockProperties.BrownMushroomShape.SIDE_N) {
                shape = BNBlockProperties.BrownMushroomShape.SIDE_S;
            } else if (shape == BNBlockProperties.BrownMushroomShape.SIDE_S) {
                shape = BNBlockProperties.BrownMushroomShape.SIDE_N;
            }
        }
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)shape));
    }

    private int getRotationIndex(BNBlockProperties.BrownMushroomShape shape, BNBlockProperties.BrownMushroomShape[] rotations) {
        for (int i = 0; i < 4; ++i) {
            if (shape != rotations[i]) continue;
            return i;
        }
        return -1;
    }

    private int rotOffset(Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return 0;
        }
        if (rotation == Rotation.CLOCKWISE_90) {
            return 1;
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return 2;
        }
        return 3;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        switch ((BNBlockProperties.BrownMushroomShape)((Object)state.m_61143_(SHAPE))) {
            case BOTTOM: {
                return state;
            }
            default: {
                return this.getStateIfSame(state, world, pos.m_7495_());
            }
            case SIDE_E: 
            case CORNER_E: {
                return this.getStateIfSame(state, world, pos.m_122024_());
            }
            case SIDE_N: 
            case CORNER_N: {
                return this.getStateIfSame(state, world, pos.m_122019_());
            }
            case SIDE_S: 
            case CORNER_S: {
                return this.getStateIfSame(state, world, pos.m_122012_());
            }
            case SIDE_W: 
            case CORNER_W: 
        }
        return this.getStateIfSame(state, world, pos.m_122029_());
    }

    private BlockState getStateIfSame(BlockState state, LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos).m_60734_() == this ? state : Blocks.f_50016_.m_49966_();
    }
}

